#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.5.9 
#-------------------------------------------------------------------------------#

start.time <- proc.time()[3]

library(AER)

#---                Data in Table 2.9   -------#
nam <- c(43, 33, 32, 35, 34, 37, 40, 34, 12, 14, 
         16, 14, 10, 12, 13, 14, 12, 12, 11, 11, 26, 11, 9, 10,
         15, 13, 19, 19, 17, 19, 17, 7, 7, 17, 
         7, 7, 7, 11, 7, 95, 23, 15, 17, 20, 7, 25, 33, 24)/1000


namc <- c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
          FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
          FALSE, FALSE, FALSE, FALSE,
          FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE,
          TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
          TRUE, FALSE, FALSE, FALSE)
censor <- rep(0, 48)

cp <- which(namc =="TRUE")
censor[cp]<- 1

censor

table29DS <- data.frame(nucleic.acid = nam, nucleic.acidCen = namc, censor = censor)
table29DS

#---  Summary statistics    ---#
aggregate(nucleic.acid~censor, data = table29DS, FUN=mean)
aggregate(nucleic.acid~censor, data = table29DS, FUN=sd)


#---  Estimate parameters for censored regression model: TOBIT ---#
fit.censored <- tobit(nucleic.acid~1, left=0.007, dist="gaussian", data = table29DS)
summary(fit.censored)

b <- coef(fit.censored)
se <- sqrt(diag(vcov(fit.censored)))

#--- Calculate confidence interval: Intercept is the average mean  ---#
cbind(LL = b - qnorm(0.975) * se, UL = b + qnorm(0.975) * se)[1,]  # Results similar to SAS
cbind(LL = b - qt(0.975, 47) * se, UL = b + qt(0.975, 47) * se)[1,]




#---   End of script    ------#
cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))
#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#